/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.gui.screens.FBTCalibrationScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.DeviceSource;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.rendertypes.VRRenderTypes;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class DebugRenderHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final class_310 MC = class_310.method_1551();

    public static void renderDebug(float partialTick) {
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderDeviceAxes) {
            DebugRenderHelper.renderDeviceAxes(DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld());
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderVrPlayerAxes) {
            DebugRenderHelper.renderPlayerAxes(partialTick);
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderTrackerPositions || DebugRenderHelper.MC.field_1755 instanceof FBTCalibrationScreen) {
            boolean showNames = true;
            class_437 class_4372 = DebugRenderHelper.MC.field_1755;
            if (class_4372 instanceof FBTCalibrationScreen) {
                FBTCalibrationScreen fbtScreen = (FBTCalibrationScreen)class_4372;
                showNames = fbtScreen.isCalibrated();
            }
            DebugRenderHelper.renderTackerPositions(showNames);
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderGameplayTrackers) {
            DATA_HOLDER.getTrackers().stream().filter(t -> DebugRenderHelper.DATA_HOLDER.vrSettings.gameplayTrackerToRender.isEmpty() || t.getClass().getName().equals(DebugRenderHelper.DATA_HOLDER.vrSettings.gameplayTrackerToRender)).forEach(t -> {
                if (t instanceof DebugRenderTracker) {
                    DebugRenderTracker debugTracker = (DebugRenderTracker)t;
                    if (t.isActive(DebugRenderHelper.MC.field_1724)) {
                        debugTracker.renderDebug();
                    }
                }
            });
        }
    }

    public static void renderPlayerAxes(float partialTick) {
        if (DebugRenderHelper.MC.field_1724 != null) {
            class_4588 consumer = null;
            class_243 camPos = DebugRenderHelper.MC.field_1773.method_19418().method_19326();
            for (class_1657 p : DebugRenderHelper.MC.field_1724.method_37908().method_18456()) {
                if (!ClientVRPlayers.getInstance().isVRPlayer((class_1297)p)) continue;
                ClientVRPlayers.RotInfo info = ClientVRPlayers.getInstance().getRotationsForPlayer(p.method_5667());
                if (consumer == null) {
                    consumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
                }
                Vector3f playerPos = MathUtils.subtractToVector3f(p.method_30950(partialTick), camPos);
                if (p == DebugRenderHelper.MC.field_1724) {
                    playerPos = MathUtils.subtractToVector3f(((GameRendererExtension)DebugRenderHelper.MC.field_1773).vivecraft$getRvePos(partialTick), camPos);
                }
                if (p != DebugRenderHelper.MC.field_1724 || DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.headPos, info.headRot, info.headQuat);
                }
                if (!info.seated) {
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.mainHandPos, info.mainHandRot, info.mainHandQuat);
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.offHandPos, info.offHandRot, info.offHandQuat);
                }
                if (info.fbtMode != FBTMode.ARMS_ONLY) {
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.waistPos, info.waistQuat);
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.rightFootPos, info.rightFootQuat);
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.leftFootPos, info.leftFootQuat);
                }
                if (info.fbtMode != FBTMode.WITH_JOINTS) continue;
                DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.rightElbowPos, info.rightElbowQuat);
                DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.leftElbowPos, info.leftElbowQuat);
                DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.rightKneePos, info.rightKneeQuat);
                DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.leftKneePos, info.leftKneeQuat);
            }
            if (consumer != null) {
                MC.method_22940().method_23000().method_22993();
            }
        }
    }

    public static void renderDeviceAxes(VRData data) {
        class_4588 consumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
        ArrayList<VRData.VRDevicePose> list = new ArrayList<VRData.VRDevicePose>();
        list.add(data.c2);
        if (DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
            list.add(data.hmd);
        }
        if (DebugRenderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
            list.add(data.cam);
        }
        if (DebugRenderHelper.MC.field_1724 != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.field_1724.method_6047()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t0);
        } else {
            list.add(DebugRenderHelper.MC.field_1724 != null && DebugRenderHelper.MC.field_1724.method_5715() ? data.h0 : data.c0);
        }
        if (DebugRenderHelper.MC.field_1724 != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.field_1724.method_6079()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t1);
        } else {
            list.add(DebugRenderHelper.MC.field_1724 != null && DebugRenderHelper.MC.field_1724.method_5715() ? data.h1 : data.c1);
        }
        if (data.fbtMode != FBTMode.ARMS_ONLY) {
            list.add(data.waist);
            list.add(data.foot_left);
            list.add(data.foot_right);
        }
        if (data.fbtMode == FBTMode.WITH_JOINTS) {
            list.add(data.elbow_left);
            list.add(data.knee_left);
            list.add(data.elbow_right);
            list.add(data.knee_right);
        }
        list.forEach(p -> DebugRenderHelper.addAxes(consumer, data, p));
        MC.method_22940().method_23000().method_22993();
    }

    private static void renderTackerPositions(boolean showNames) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        class_243 camPos = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getPosition();
        Quaternionf orientation = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        class_2561[] labels = new class_2561[]{class_2561.method_43471((String)"vivecraft.toasts.point_controller.right"), class_2561.method_43471((String)"vivecraft.toasts.point_controller.left"), class_2561.method_43471((String)"vivecraft.messages.tracker.camera"), class_2561.method_43471((String)"vivecraft.messages.tracker.waist"), class_2561.method_43471((String)"vivecraft.messages.tracker.rightFoot"), class_2561.method_43471((String)"vivecraft.messages.tracker.leftFoot"), class_2561.method_43471((String)"vivecraft.messages.tracker.rightElbow"), class_2561.method_43471((String)"vivecraft.messages.tracker.leftElbow"), class_2561.method_43471((String)"vivecraft.messages.tracker.rightKnee"), class_2561.method_43471((String)"vivecraft.messages.tracker.leftKnee")};
        for (Triple<DeviceSource, Integer, Matrix4fc> tracker : MCVR.get().getTrackers()) {
            Vector3f pos = ((Matrix4fc)tracker.getRight()).getTranslation(new Vector3f());
            class_243 trackerPos = VRPlayer.roomToWorldPos((Vector3fc)pos, data).method_1020(camPos);
            pos.set((float)trackerPos.field_1352, (float)trackerPos.field_1351, (float)trackerPos.field_1350);
            if (showNames) {
                if ((Integer)tracker.getMiddle() >= 0) {
                    DebugRenderHelper.addNamedCube((Vector3fc)pos, orientation, (class_2561)class_2561.method_43469((String)"vivecraft.formatting.name_value", (Object[])new Object[]{class_2561.method_43470((String)((DeviceSource)tracker.getLeft()).source.toString()), labels[(Integer)tracker.getMiddle()]}), 0.05f, MathUtils.DARK_GRAY);
                    continue;
                }
                DebugRenderHelper.addNamedCube((Vector3fc)pos, orientation, (class_2561)class_2561.method_43469((String)"vivecraft.formatting.name_value", (Object[])new Object[]{class_2561.method_43470((String)(((DeviceSource)tracker.getLeft()).source.toString() + ((DeviceSource)tracker.getLeft()).deviceIndex)), class_2561.method_43471((String)"vivecraft.messages.tracker.unknown")}), 0.05f, MathUtils.DARK_GRAY);
                continue;
            }
            DebugRenderHelper.renderCube((Vector3fc)pos, 0.05f, MathUtils.DARK_GRAY);
        }
        MC.method_22940().method_23000().method_37104();
    }

    public static void renderLocalAxes(Matrix4f matrix) {
        RenderSystem.getModelViewStack().pushMatrix().mul((Matrix4fc)matrix);
        class_4588 consumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
        Vector3f position = new Vector3f();
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, MathUtils.BACK, MathUtils.BLUE);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, MathUtils.UP, MathUtils.GREEN);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, MathUtils.RIGHT, MathUtils.RED);
        MC.method_22940().method_23000().method_22993();
        RenderSystem.getModelViewStack().popMatrix();
    }

    private static void addAxes(class_4588 consumer, VRData data, VRData.VRDevicePose pose) {
        Vector3f position = MathUtils.subtractToVector3f(pose.getPosition(), data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getPosition());
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = pose.getDirection().mul(scale);
        Vector3f up = pose.getCustomVector(MathUtils.UP).mul(scale);
        Vector3f right = pose.getCustomVector(MathUtils.RIGHT).mul(scale);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)forward, MathUtils.BLUE);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)up, MathUtils.GREEN);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)right, MathUtils.RED);
    }

    private static void addAxes(class_4588 consumer, Vector3fc playerPos, Vector3fc devicePos, Quaternionfc rot) {
        DebugRenderHelper.addAxes(consumer, playerPos, devicePos, (Vector3fc)rot.transform(MathUtils.BACK, new Vector3f()), rot);
    }

    private static void addAxes(class_4588 consumer, Vector3fc playerPos, Vector3fc devicePos, Vector3fc dir, Quaternionfc rot) {
        Vector3f position = playerPos.add(devicePos, new Vector3f());
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = dir.mul(scale, new Vector3f());
        Vector3f up = rot.transform(MathUtils.UP, new Vector3f()).mul(scale);
        Vector3f right = rot.transform(MathUtils.RIGHT, new Vector3f()).mul(scale);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)forward, MathUtils.BLUE);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)up, MathUtils.GREEN);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)right, MathUtils.RED);
    }

    private static void addLine(class_4588 consumer, Vector3fc position, Vector3fc dir, Vector3fc color) {
        consumer.method_22912(position.x(), position.y(), position.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
        consumer.method_22912(position.x(), position.y(), position.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
        consumer.method_22912(position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
        consumer.method_22912(position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
    }

    public static void renderLine(Vector3fc color, Vector3fc ... points) {
        class_4588 vertexConsumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
        for (Vector3fc point : points) {
            vertexConsumer.method_22912(point.x(), point.y(), point.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
        }
        MC.method_22940().method_23000().method_22993();
    }

    public static void renderLine(List<Pair<Vector3fc, Boolean>> points, Vector3fc color) {
        class_4588 vertexConsumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
        Pair<Vector3fc, Boolean> prev = null;
        for (Pair<Vector3fc, Boolean> point : points) {
            if (((Boolean)point.getRight()).booleanValue() && prev != null) {
                vertexConsumer.method_22912(((Vector3fc)prev.getLeft()).x(), ((Vector3fc)prev.getLeft()).y(), ((Vector3fc)prev.getLeft()).z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
                vertexConsumer.method_22912(((Vector3fc)point.getLeft()).x(), ((Vector3fc)point.getLeft()).y(), ((Vector3fc)point.getLeft()).z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
            }
            vertexConsumer.method_22912(((Vector3fc)point.getLeft()).x(), ((Vector3fc)point.getLeft()).y(), ((Vector3fc)point.getLeft()).z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
            prev = point;
        }
        MC.method_22940().method_23000().method_22993();
    }

    public static void renderLine(Vector3fc color, class_243 camPos, Iterable<class_243> points) {
        class_4588 vertexConsumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
        for (class_243 point : points) {
            vertexConsumer.method_22912((float)(point.method_10216() - camPos.method_10216()), (float)(point.method_10214() - camPos.method_10214()), (float)(point.method_10215() - camPos.method_10215())).method_22915(color.x(), color.y(), color.z(), 1.0f);
        }
        MC.method_22940().method_23000().method_22993();
    }

    private static void addNamedCube(Vector3fc cubePos, Quaternionf rot, class_2561 label, float size, Vector3fc color) {
        DebugRenderHelper.renderCube(cubePos, size, color);
        if (label != null) {
            DebugRenderHelper.renderTextAtRelativePosition(cubePos.x(), cubePos.y(), cubePos.z(), rot, label);
        }
    }

    public static void renderTextAtDevice(class_4587 poseStack, int device, String text) {
        DebugRenderHelper.renderTextAtPosition(poseStack, DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld().getDevice(device).getPosition(), text);
    }

    public static void renderTextAtPosition(class_4587 poseStack, class_243 position, String text) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        class_243 camPos = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getPosition();
        Quaternionf rot = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        Vector3f pos = MathUtils.subtractToVector3f(position, camPos);
        DebugRenderHelper.renderTextAtRelativePosition(pos.x, pos.y, pos.z, rot, text);
    }

    public static void renderTextAtRelativePosition(float x, float y, float z, Quaternionf rot, String text) {
        DebugRenderHelper.renderTextAtRelativePosition(x, y, z, rot, (class_2561)class_2561.method_43470((String)text));
    }

    public static void renderTextAtRelativePosition(float x, float y, float z, Quaternionf rot, class_2561 text) {
        Matrix4f matrix = new Matrix4f();
        matrix.translate(x, y + 0.05f, z);
        matrix.rotate((Quaternionfc)rot);
        matrix.scale(-0.005f, -0.005f, 0.005f);
        class_327 class_3272 = DebugRenderHelper.MC.field_1772;
        float f = (float)DebugRenderHelper.MC.field_1772.method_27525((class_5348)text) * -0.5f;
        Objects.requireNonNull(DebugRenderHelper.MC.field_1772);
        class_3272.method_27522(text, f, (float)(-9), -1, false, matrix, (class_4597)MC.method_22940().method_23000(), class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public static void renderCube(Vector3fc position, float size, Vector3fc color) {
        ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
        class_1921 renderType = VRRenderTypes.quads(false);
        class_4588 consumer = MC.method_22940().method_23000().getBuffer(renderType);
        class_2382 iColor = new class_2382((int)(color.x() * 255.0f), (int)(color.y() * 255.0f), (int)(color.z() * 255.0f));
        class_243 start = new class_243((double)position.x(), (double)position.y(), (double)position.z()).method_1019(MathUtils.FORWARD_D.method_1021((double)(size * 0.5f)));
        class_243 end = new class_243((double)position.x(), (double)position.y(), (double)position.z()).method_1019(MathUtils.BACK_D.method_1021((double)(size * 0.5f)));
        RenderHelper.renderBox(consumer, start, end, size, size, iColor, (byte)-1, new Matrix4f());
        MC.method_22940().method_23000().method_22993();
    }

    public static void addCircle(class_4588 vertexConsumer, Vector3fc center, Vector3fc forward, float radius, Vector3fc color) {
        Vector3f offset = MathUtils.getPerpendicularVec(forward).mul(radius);
        vertexConsumer.method_22912(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
        for (int i = 0; i <= 20; ++i) {
            vertexConsumer.method_22912(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
            if (i == 20) continue;
            offset.rotateAxis(0.31415927f, forward.x(), forward.y(), forward.z());
        }
        vertexConsumer.method_22912(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
    }

    public static void renderCircle(Vector3fc center, Vector3fc forward, float radius, Vector3fc color) {
        class_4588 vertexConsumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
        DebugRenderHelper.addCircle(vertexConsumer, center, forward, radius, color);
        MC.method_22940().method_23000().method_22993();
    }

    public static void renderSphere(Vector3fc center, float radius, Vector3fc color) {
        class_4588 vertexConsumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
        DebugRenderHelper.addCircle(vertexConsumer, center, MathUtils.LEFT, radius, color);
        DebugRenderHelper.addCircle(vertexConsumer, center, MathUtils.FORWARD, radius, color);
        DebugRenderHelper.addCircle(vertexConsumer, center, MathUtils.UP, radius, color);
        MC.method_22940().method_23000().method_22993();
    }

    public static void renderCone(Vector3fc tip, Vector3fc dir, float angle, float length, Vector3fc color) {
        class_4588 vertexConsumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
        Vector3f center = dir.normalize(new Vector3f()).mul(length).add(tip);
        float radius = length * (float)Math.tan(Math.toRadians(angle));
        DebugRenderHelper.addCircle(vertexConsumer, (Vector3fc)center, dir, radius, color);
        Vector3f offset = MathUtils.getPerpendicularVec(dir).mul(radius);
        for (int i = 0; i < 2; ++i) {
            vertexConsumer.method_22912(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
            vertexConsumer.method_22912(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.method_22912(tip.x(), tip.y(), tip.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.method_22912(center.x() - offset.x(), center.y() - offset.y(), center.z() - offset.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.method_22912(center.x() - offset.x(), center.y() - offset.y(), center.z() - offset.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
            offset.rotateAxis(1.5707964f, dir.x(), dir.y(), dir.z());
        }
        MC.method_22940().method_23000().method_22993();
    }

    public static void renderCylinder(Vector3fc bottom, Vector3fc topDir, float radius, Vector3fc color) {
        class_4588 vertexConsumer = MC.method_22940().method_23000().getBuffer(class_1921.method_49043((double)2.0));
        Vector3f dir = topDir.normalize(new Vector3f());
        DebugRenderHelper.addCircle(vertexConsumer, bottom, (Vector3fc)dir, radius, color);
        DebugRenderHelper.addCircle(vertexConsumer, (Vector3fc)bottom.add(topDir, new Vector3f()), (Vector3fc)dir, radius, color);
        Vector3f offset = MathUtils.getPerpendicularVec(topDir).mul(radius);
        for (int i = 0; i < 4; ++i) {
            Vector3f bot = bottom.add((Vector3fc)offset, new Vector3f());
            Vector3f top = bot.add(topDir, new Vector3f());
            vertexConsumer.method_22912(bot.x(), bot.y(), bot.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
            vertexConsumer.method_22912(bot.x(), bot.y(), bot.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.method_22912(top.x(), top.y(), top.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.method_22912(top.x(), top.y(), top.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
            offset.rotateAxis(1.5707964f, dir.x(), dir.y(), dir.z());
        }
        MC.method_22940().method_23000().method_22993();
    }

    public static void renderAABB(class_238 aabb, Vector3fc color) {
        DebugRenderHelper.renderCubeOutline((Vector3fc)new Vector3f((float)aabb.field_1323, (float)aabb.field_1322, (float)aabb.field_1321), (Vector3fc)new Vector3f((float)aabb.field_1323, (float)aabb.field_1325, (float)aabb.field_1321), (Vector3fc)new Vector3f((float)aabb.field_1323, (float)aabb.field_1325, (float)aabb.field_1324), (Vector3fc)new Vector3f((float)aabb.field_1323, (float)aabb.field_1322, (float)aabb.field_1324), (Vector3fc)new Vector3f((float)aabb.field_1320, (float)aabb.field_1322, (float)aabb.field_1321), (Vector3fc)new Vector3f((float)aabb.field_1320, (float)aabb.field_1325, (float)aabb.field_1321), (Vector3fc)new Vector3f((float)aabb.field_1320, (float)aabb.field_1325, (float)aabb.field_1324), (Vector3fc)new Vector3f((float)aabb.field_1320, (float)aabb.field_1322, (float)aabb.field_1324), color);
    }

    public static void renderCubeOutline(Vector3fc v0, Vector3fc v1, Vector3fc v2, Vector3fc v3, Vector3fc v4, Vector3fc v5, Vector3fc v6, Vector3fc v7, Vector3fc color) {
        DebugRenderHelper.renderLine(List.of(Pair.of((Object)v0, (Object)false), Pair.of((Object)v1, (Object)false), Pair.of((Object)v2, (Object)false), Pair.of((Object)v3, (Object)false), Pair.of((Object)v0, (Object)false), Pair.of((Object)v4, (Object)false), Pair.of((Object)v5, (Object)false), Pair.of((Object)v6, (Object)false), Pair.of((Object)v7, (Object)false), Pair.of((Object)v4, (Object)false), Pair.of((Object)v1, (Object)true), Pair.of((Object)v5, (Object)false), Pair.of((Object)v2, (Object)true), Pair.of((Object)v6, (Object)false), Pair.of((Object)v3, (Object)true), Pair.of((Object)v7, (Object)false)), color);
    }
}

